import { Scale, Mail, Phone, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Scale size={28} strokeWidth={2} className="footer-logo-icon" />
              <h2 className="footer-logo-text">LegalHub</h2>
            </div>
            <p className="footer-description">
              Профессиональные юридические консультации. 
              Защита ваших прав и интересов.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@legalhub.ru">info@legalhub.ru</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>г. Москва, ул. Юридическая, д. 25</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Семейное право</a></li>
              <li><a href="#">Трудовое право</a></li>
              <li><a href="#">Жилищное право</a></li>
              <li><a href="#">Уголовное право</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Пн-Пт: 9:00 - 21:00</span>
              </li>
              <li>
                <Clock size={16} strokeWidth={2} />
                <span>Сб-Вс: 10:00 - 18:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 LegalHub. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

